﻿$(document).ready(function () {
    $(".fileUpload").on("click", ".clearFileButton", function () {
        var context = $(this).closest(".fileUpload");
        clearFile(context);
    });

    $(".fileUpload").on("change", ":file", function (event) {
        var files = event.originalEvent.target.files
        var context = $(this).closest(".fileUpload");
        var inputFileContainer = $(".inputFileContainer", context);
        var errorMessageDiv = $(".errorMessage", context);
        var maxFileSize = inputFileContainer.attr("data-maxfilesize");
        var noFileChosenMessage = inputFileContainer.attr("data-nofilechosenmessage");

        if (validateFileSize(event, maxFileSize)) {
            if (files.length > 0) {
                $(".file-name-section", context).text(files[0].name);
            }
            else {
                $(".file-name-section", context).text(noFileChosenMessage);
            }
            $(".clearFileButton", context).show();
            errorMessageDiv.hide();
        }
        else {
            var errorMessage = inputFileContainer.attr("data-maxfilesizemessage");

            if (errorMessageDiv.length > 0) {
                errorMessageDiv.show();
                errorMessageDiv.text(errorMessage);
            }
            else {
                context.append($("<div />", { "class": "errorMessageContainer" }).append($("<div />", { "class": "errorMessage", "role": "alert"}).append(errorMessage)));
            }

            $(".deleteFile", context).val("delete").trigger("change");
            $(".fileLink", context).remove();
            $(".clearFileButton", context).hide();
            $(".file-name-section", context).text(noFileChosenMessage);
        }
    });
});

function validateFileSize(event, maxFileSize) {
    var fileSize = 0;
    var isValid = true;

    if (event.originalEvent && event.originalEvent.target.files) {
        var files = event.originalEvent.target.files;
        if (files[0]) {
            fileSize = files[0].size;
        }
    }

    return (fileSize / 1024) <= parseInt(maxFileSize);
}